# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 6
# Experiment: PMxPM, Run: 5
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR6(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Round 1: Cooperate to establish goodwill
    if current_round == 1:
        return "C"
    
    # Round 10: Defect unconditionally
    if current_round == 10:
        return "D"
    
    # Rounds 2-7: Probabilistic Tit-for-Tat
    if 2 <= current_round <= 7:
        if opp_history[-1] == "C":
            return "C" if random.random() < 0.8 else "D"
        else:
            return "D" if random.random() < 0.9 else "C"
    
    # Rounds 8-9: Grim trigger
    if current_round >= 8:
        if "D" in opp_history[:7]:
            return "D"
        else:
            return "C"
    
    # Fallback (should not reach here)
    return "C"